Scriptname zBFSIceNormal extends activemagiceffect  

Spell property BFSDeadSpell auto
Spell property BFSDeadMagicSpell auto
Spell property BFSDeadShaderSpell auto

EffectShader property BlankShader auto
EffectShader property IceEffectShader auto
EffectShader property FreezeTexture auto
EffectShader property FreezeTextureInstant auto

GlobalVariable property GlobalEffectChance auto
GlobalVariable property GlobalEffectChanceNPC auto
GlobalVariable property GlobalEffectChanceR2 auto
GlobalVariable property GlobalEffectChanceR2NPC auto

Perk property AugmentedFrost auto
Perk property AugmentedFrost60 auto

Race property AlduinRace auto
Race property DragonRace auto

actor caster
actor target
race casterrace
int random
int randomEffect100
int randomR2Effect100
float GlobalChance
float GlobalChanceNPC
float GlobalChanceR2
float GlobalChanceR2NPC
bool bShader = false

;;; NOTE: Ice effects are trickier than fire or shock effects to apply, be carefull when modifying this

EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	caster = akCaster
	target = akTarget
	casterrace = caster.GetRace()
	randomEffect100 = Utility.RandomInt(0, 100)
	randomR2Effect100 = Utility.RandomInt(0, 100)
endEvent


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	GlobalChance = GlobalEffectChance.GetValue()
	GlobalChanceNPC = GlobalEffectChanceNPC.GetValue()
	GlobalChanceR2 = GlobalEffectChanceR2.GetValue()
	GlobalChanceR2NPC = GlobalEffectChanceR2NPC.GetValue()

	if target.IsDead()
		;;; if has augmented Frost perk only and IS NOT a Dragon apply freeze texture
		if (caster.HasPerk(AugmentedFrost) && !caster.HasPerk(AugmentedFrost60) && casterrace != DragonRace && casterrace != AlduinRace ) && !target.HasSpell(BFSDeadShaderSpell)
			target.AddSpell(BFSDeadSpell, false)
			target.AddSpell(BFSDeadShaderSpell, false)
			BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
			bShader = true
			FreezeTexture.play(target)
		endif
		;;; if has augmented Frost(rank 2) perk OR is a Dragon apply the ice spiked effect
		if (casterrace == DragonRace || casterrace == AlduinRace || (caster == Game.GetPlayer() && randomEffect100 <= GlobalChance) || (caster != Game.GetPlayer() && randomEffect100 <= GlobalChanceNPC) \
		|| (caster.HasPerk(AugmentedFrost60) && caster == Game.GetPlayer() && randomR2Effect100 <= GlobalChanceR2) || (caster.HasPerk(AugmentedFrost60) && caster != Game.GetPlayer() && randomR2Effect100 <= GlobalChanceR2NPC) ) && !target.HasSpell(BFSDeadMagicSpell)
			target.AddSpell(BFSDeadSpell, false)
			target.AddSpell(BFSDeadMagicSpell, false)
			target.AddSpell(BFSDeadShaderSpell, false)
			BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
			IceEffectShader.play(target)
			bShader = true
			FreezeTexture.play(target)
		endif
	endif

	if bShader == true
		FreezeTextureInstant.play(target)
	endif
endEvent